/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.datagen.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.hecco.bountifulfares.recipe.MillingRecipe;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class MillingRecipeBuilder
implements RecipeBuilder {
    public final String detailedId;
    private final Item result;
    private final Ingredient ingredient;
    private final int count;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();

    public MillingRecipeBuilder(ItemLike ingredient, ItemLike output, int count, String detailedId) {
        this.detailedId = detailedId;
        this.ingredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient});
        this.result = output.m_5456_();
        this.count = count;
    }

    public RecipeBuilder m_126132_(String name, CriterionTriggerInstance conditions) {
        this.advancement.m_138386_(name, conditions);
        return this;
    }

    public RecipeBuilder m_126145_(@Nullable String group) {
        return this;
    }

    public Item m_142372_() {
        return this.result;
    }

    public void m_126140_(Consumer<FinishedRecipe> exporter, ResourceLocation recipeId) {
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)recipeId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)recipeId));
        exporter.accept(new JsonBuilder(this.detailedId, recipeId, this.result, this.count, this.ingredient, this.advancement, new ResourceLocation(recipeId.m_135827_(), "recipes/" + recipeId.m_135815_())));
    }

    public static class JsonBuilder
    implements FinishedRecipe {
        public final String detailedId;
        private final ResourceLocation id;
        private final Item result;
        private final Ingredient ingredient;
        private final int count;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public JsonBuilder(String detailedId, ResourceLocation id, Item result, int count, Ingredient ingredient, Advancement.Builder advancement, ResourceLocation advancementId) {
            this.detailedId = detailedId;
            this.id = id;
            this.result = result;
            this.ingredient = ingredient;
            this.count = count;
            this.advancement = advancement;
            this.advancementId = advancementId;
        }

        public void m_7917_(JsonObject json) {
            JsonArray jsonarray = new JsonArray();
            jsonarray.add(this.ingredient.m_43942_());
            json.add("ingredients", (JsonElement)jsonarray);
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)this.result).toString());
            if (this.count > 1) {
                jsonobject.addProperty("count", (Number)this.count);
            }
            json.add("output", (JsonElement)jsonobject);
        }

        public ResourceLocation m_6445_() {
            if (this.detailedId != null) {
                return new ResourceLocation("bountifulfares", BuiltInRegistries.f_257033_.m_7981_((Object)this.result).m_135815_() + "_from_milling_" + this.detailedId);
            }
            return new ResourceLocation("bountifulfares", BuiltInRegistries.f_257033_.m_7981_((Object)this.result).m_135815_() + "_from_milling");
        }

        public RecipeSerializer<?> m_6637_() {
            return MillingRecipe.Serializer.INSTANCE;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

